// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script prompts for a PBN file and finds the boards in it
//  for which a grand slam is makeable.
//  It then prompts for a new file in which to save those
//  grand-slam boards.
//  Revised 2018-06-11

var out = WScript.CreateObject('BridgeComposer.Object');
var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0) {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}
bc.DoubleDummyAllBoards();
var bds = bc.Boards;
var s = '';
for (var i = 0; i < bds.Count; ++i) {
  var b = bds.Item(i);
  if (b.TagValue('DoubleDummyTricks').indexOf('d') >= 0) {
    s += ' ' + b.TagValue('Board');
    var pbn = b.toPbn();
    out.ParsePbn(pbn);
  }
}
if (s.length == 0) {
  WScript.Echo('No makeable grand slams found');
}
else
{
  WScript.Echo('Makeable grand slam on boards:\n', s);
  out.Save();
}
