// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  BridgeComposer does not display the player names in a PBN file
//  unless an auction is present. This script copies the player names
//  to a commentary section so they can be seen.

//  $Id: ShowPlayerNames.js 111 2022-09-13 12:51:35Z Ray $

var nMod = 0;

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

//  "section" parameter values for the Board object "Commentary" property:

var CMTY_EVENT = 0;
var CMTY_DIAGRAM = 1;
var CMTY_AUCTION = 2;
var CMTY_FINAL = 3;

var vpn = ['North', 'South', 'West', 'East'];

var bds = bc.Boards;
while (bds.MoveNext()) {
  var bd = bds.Current;
  var strnames = '';
  for (var ix in vpn) {
    var strtag = vpn[ix];
    var strpn = bd.TagValue(strtag);
    if (strpn) {
      if (strnames)
        strnames += '\\n\n';
      
      strnames += strtag + ': ' + strpn;
    }
  }

  if (strnames)
  {
    bd.Commentary(CMTY_EVENT) += '\n\n' + strnames + '\n';

    var flg = parseInt(bd.TagValue('BCFlags'), 16);
    flg |= 0x20;  // show Event Commentary
    bd.TagValue('BCFlags') = flg.toString(16);

    ++nMod;
  }
}

if (nMod)
  bc.Save();
