// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  Fix up a SharkBridge PBN file opened in BridgeComposer.
//  Note: This is a work in progress. If you have a SharkBridge PBN file
//  that does not display properly in BridgeComposer, please email it to:
//  support@bridgecomposer.com

//  $Id: SharkFix.js 84 2022-01-07 12:32:45Z Ray $

var nMod = 0;

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

function FixPlayerName(tag)
{
  //  Remove redundant player name settings like [West "West"]

  var strName = bd.TagValue(tag);
  if (strName === tag) {
    bd.TagValue(tag) = '';
    ++nMod;
  }
}

var bds = bc.Boards;
while (bds.MoveNext()) {
  var bd = bds.Current;

  FixPlayerName('West');
  FixPlayerName('North');
  FixPlayerName('East');
  FixPlayerName('South');

  // BC (version 5.93) mishandles Result tag when Play is incomplete

  var strResult = bd.TagValue('Result');
  if (strResult === '0') {
    bd.TagValue('Result') = '';
    ++nMod;
  }

  // BC interprets "+" in the Play section in a special way, so remove it.
  // Here we assume the Play section is always a single card (opening lead).

  var strPlay = bd.TagSection('Play');
  var strLead = '';
  if (strPlay.length >= 2) {
    strLead = strPlay.substr(0, 2);
    bd.TagSection('Play') = strLead;
    ++nMod;
  }

  // SharkBridge may incorrectly have board commentary right after the last Play section token,
  // which makes that commentary apply to the token, not the board. Fix this.

  var ixLeft = strPlay.indexOf('{');
  if (ixLeft >= 0) {
    var ixRight = strPlay.indexOf('}');
    if (ixRight >= 0) {
      var strComment = strPlay.substring(ixLeft + 1, ixRight - 1);
      var strCmty = bd.Commentary(3);
      strCmty += strComment;
      bd.Commentary(3) = strCmty;
      ++nMod;
    }
  }

  // SharkBridge begins the commentary by showing the South hand. Remove this.

  var strCmty = bd.Commentary(3);
  if (strCmty.length > 19 && strCmty.substr(0, 3) === '\r\n#') {
    var ix = strCmty.indexOf('\r\n', 3);
    var strFix = strCmty.substr(ix + 2);
    bd.Commentary(3) = strFix;
    ++nMod;
  }
}

if (nMod)
  bc.Save();
