// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  Randomly reorder the boards in a document.
//
//  $Id: ScrambleBoards.js 100 2022-07-06 22:26:32Z Ray $

var bc;       // BridgeComposer object

function Shuffle(X, t) {
  //  See Algorithm P (Shuffling), Knuth TAOCP vol. 2 (3rd ed.), sec. 3.4.2.
  //  We generate a random perumutation of {0, 1, ..., t - 1} in X[0], X[1], ..., X[t - 1].
  for (var j = 0; j < t; j++) {
    var k = bc.Random(j + 1);   // k uniformly distributed >= 0 and <= j
    X[j] = X[k];
    X[k] = j;
  }
}

(function () {
  bc = WScript.CreateObject('BridgeComposer.Object');
  if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
    bc.Open(WScript.Arguments(0));
  } else {
    if (!bc.Open()) WScript.Quit();
  }
  
  var vBoard = [];
  var bds = bc.Boards;
  var cBoards = bds.Count;
  for (var iBoard = cBoards - 1; iBoard >= 0; iBoard--) {
    var bd = bds.Item(iBoard);
    vBoard.push(bd.toPbn());
    bc.DeleteBoard(iBoard);
  }

  var vIndex = [];
  Shuffle(vIndex, vBoard.length);
  for (var iBoard = 0; iBoard < vBoard.length; ++iBoard) {
    bc.ParsePbn(vBoard[vIndex[iBoard]]);
  }

  bc.Save();
})();
