// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script generates 100 boards with fixed North/South hands
//  and random East/West hands. Then the double dummy analyses
//  are computed and the file is saved.
//  Revised 2018-06-11

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0) {
  bc.Open(WScript.Arguments(0));
}

function PromptForHand(strHolding, iHand)
{
  var strHand = ['North', 'East', 'South', 'West'][iHand];
  while (true) {
    strHolding = bc.prompt('Enter ' + strHand + ' hand', strHolding);
    if (!strHolding) WScript.Quit();
    var strError = bc.ValidateHand(strHolding, iHand);
    if (!strError) return strHolding;
    bc.alert(strError);
  }
}

var strNorth = 'at53.aq.akq643.7';
var strSouth = 'k84.k7.jt72.aj86';
while (true) {
  strNorth = PromptForHand(strNorth, 0);
  strSouth = PromptForHand(strSouth, 2);
  var strDeal = 'n:' + strNorth + ' - ' + strSouth + ' -';
  var strError = bc.ValidateDeal(strDeal);
  if (!strError) break;
  bc.alert(strError);
}
for (var i = 0; i < 100; ++i) {
  var b = bc.NewBoard();
  b.TagValue('Board') = i + 1;
  b.TagValue('Dealer') = 'W';
  b.TagValue('Vulnerable') = 'All';
  b.TagValue('Deal') = strDeal;
  b.RandomAutofill();
}
bc.DoubleDummyAllBoards();
bc.Save();
