// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script hides the names in ScoreTables
//  by renaming their columns.
//  Revised 2018-06-11

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0) {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}
var cb = bc.Boards.Count;
var mod = 0;
for (var ix = 0; ix < cb; ++ix) {
  var brd = bc.Boards.Item(ix);
  var s1 = brd.TagValue('ScoreTable');
  var s2 = s1.replace(';Names_NS', ';Xnames_NS');
  var s3 = s2.replace(';Names_EW', ';Xnames_EW');
  if (s3 != s1) {
    brd.TagValue('ScoreTable') = s3;
    ++mod;
  }
}
if (mod) bc.Save();
