// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  This script sets the Room tag in the selected board.
//  You may pass an argument of 0, 1, or 2:
//    0 = clear the Room tag
//    1 = set the Room tag to Open
//    2 = set the Room tag to Closed
//
//  If you do not pass an argument, you will be prompted for it.
//
//  $Id: RoomSet.js 120 2022-11-07 12:53:47Z Ray $


//  Message box severity

var MB_ICONINFORMATION = 64;
var MB_ICONWARNING = 48, MB_ICONEXCLAMATION = 48; // (synonyms)
var MB_ICONERROR = 16, MB_ICONSTOP = 16; // (synonyms)


(function () {
  bc = WScript.CreateObject('BridgeComposer.Object');
  if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
    bc.Open(WScript.Arguments(0));
  } else {
    if (!bc.Open()) WScript.Quit();
  }

  var ix = bc.SelectedBoard;
  var bd = bc.Boards.Item(ix);

  var strnRoom = 0;
  if (WScript.Arguments.length > 1) {
    strnRoom = WScript.Arguments(1);
  } else {
    for (;;) {
      var strPrompt = 'Enter room for board ' + bd.UniqueBoard;
      strPrompt += '\n\n0 = [empty]';
      strPrompt += '\n1 = Open';
      strPrompt += '\n2 = Closed';
      var strnRoom = bc.prompt(strPrompt, 0);
      if (strnRoom === null)
        WScript.Quit();

      if (strnRoom >= 0 && strnRoom <= 2)
        break;
    }
  }

  if (strnRoom >= 0 && strnRoom <= 2) {
    bd.TagValue('Room') = ['', 'Open', 'Closed'][strnRoom];
  } else {
    bc.alert('RoomSet.js: Argument out of range: ' + strnRoom, MB_ICONERROR);
    WScript.Quit(1);
  }

  bc.Save();
})();
