// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script clears the [Room] tag in all boards in a PBN file.
//  The [Room] tag cannot be set using BridgeComposer, but it may be set
//  in documents created by other programs.
//  For example, it is typically set to "Open" or "Closed" when
//  BridgeComposer imports BBO LIN files.
//  BridgeComposer displays the [Room] tag in its toolbar drop-down
//  board selector.
//  Revised 2018-06-11

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0) {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}
var cb = bc.Boards.Count;
var mod = 0;
for (var ix = 0; ix < cb; ++ix) {
  var brd = bc.Boards.Item(ix);
  if (brd.TagValue('Room') != '') {
    brd.TagValue('Room') = '';
    ++mod;
  }
}
if (mod) bc.Save();
