// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script scans commentary in all boards of a PBN file,
//  replacing the UNICODE "white" heart and diamond characters
//  with the corresponding BridgeComposer pips.

//  $Id: RedShift.js 63 2021-09-15 19:18:34Z Ray $

var nMod = 0;

function CheckText(str)
{
  var cch = str.length;
  var strnew = '';
  for (var i = 0; i < cch; ++i) {
    var ch = str.charAt(i);
    var chnew = '';
    switch (ch) {
    case '\u2661':
      chnew = 'H';
      break;

    case '\u2662':
      chnew = 'D';
      break;
    }

    if (chnew) {
      strnew += '\\' + chnew;
      ++nMod;
    } else {
      strnew += ch;
    }
  }

  return strnew;
}

function CheckCmty(bd, iSection)
{
  var str = bd.Commentary(iSection);
  var strnew = CheckText(str);
  bd.Commentary(iSection) = strnew;
}

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

var bds = bc.Boards;
while (bds.MoveNext()) {
  var bd = bds.Current;
  for (var iSection = 0; iSection < 4; ++iSection) {
    CheckCmty(bd, iSection);
  }
}

if (nMod)
  bc.Save();
