// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script scans a folder for PBN files
//  and converts them to LIN files.
//
//  You must have NetBridgeVu installed on your computer.
//  See BridgeComposer "Help>Help Topics", Index tab: NetBridgeVu

//  $Id: PBNtoLIN.js 233 2025-05-20 12:32:43Z Ray $


//  Set the variable LinFormat to the format you want:
//    0 = classic (for display by the NetBridgeVu desktop app)
//    1 = modern (for display by the HandViewer web app)
//    2 = archive (for import to your BBO deal archive)
//    3 = classic+ (classic with LIN command reordering)

var LinFormat = 2;


var MB_ICONINFORMATION = 64;
var MB_ICONWARNING = 48, MB_ICONEXCLAMATION = 48;
var MB_ICONERROR = 16, MB_ICONSTOP = 16;
var MB_YESNO = 4;
var MB_RETRYCANCEL = 5;
var MB_DEFBUTTON2 = 256;
var BCP_UPDATE = 0; // update progress
var BCP_TITLE = 1;  // set progress panel title
var BCP_CLOSE = 2;  // close progress panel
var BCP_BUTTON = 3; // set button label
var BCP_FINISH = 4; // change to "alert" box

function GetBC(minver)
{
  if (minver) {
    if (typeof minver !== 'string')
      throw 'GetBC argument must be a string, because trailing zeros are significant'
  } else {
    minver = '5.61';  // default if "minver" omitted
  }
  
  try {
    var bc = WScript.CreateObject('BridgeComposer.Object');
  } catch (e) {
    WScript.Echo('To run this script, you need to install BridgeComposer ' +
      '(version ' + minver + ' or later).\r\n\r\n' +
      'Visit https://bridgecomposer.com and click "Download Now".');
    WScript.Quit(1);
  }
  
  var arrMin = minver.split('.');
  while (arrMin.length < 3)
    arrMin.push(0);
  
  var arrNow = bc.Version.split('.');
  while (arrNow.length < 3)
    arrNow.push(0);
  
  for (var i = 0; i < 3; ++i) {
    arrMin[i] = parseInt(arrMin[i]);
    arrNow[i] = parseInt(arrNow[i]);
    if (arrNow[i] > arrMin[i])
      break;
    
    if (arrNow[i] < arrMin[i]) {
      WScript.Echo('To run this script, you need to update BridgeComposer ' +
        'to version ' + minver + ' or later.\n\n' +
        'In BridgeComposer, use the "Help>Check For Updates" menu command.');
      WScript.Quit(1);
    }
  }
  
  return bc;
}

function Exit(rc)
{
  var disp = (rc) ? "canceled" : "complete";
  bc.progress(BCP_FINISH, 'PBNtoLIN ' + disp + ': ' + nFind + ' converted\n' + strFind);
  WScript.Quit(rc);
}

function ScanFolder(fldr)
{
  //if (!bc.confirm('Scanning folder ' + fldr.Self.Path, 0)) WScript.Quit();
  var items = fldr.Items();
  for (var i = 0; i < items.Count; ++i) {
    var item = items.Item(i);
    if (item.IsFolder) {
      if (bSubfolders) {
        var fname = item.Name;
        var ixx = fname.lastIndexOf('.');
        if (ixx >= 0) {
          var ftype = fname.slice(ixx + 1);
          ftype = ftype.toLowerCase();
          if (ftype === 'zip' || ftype === 'cab') continue;
        }

        ScanFolder(item.GetFolder);
      }
    } else {
      ScanFile(item);
    }
  }
}

function ScanFile(item)
{
  //if (!bc.confirm('Scanning file ' + item.Path, 0)) WScript.Quit();
  var fname = item.Name;
  if (!bc.progress(BCP_UPDATE, 'Scanning ' + item.Path + '\n' + nFind + ' found')) Exit(1);
  var ixx = fname.lastIndexOf('.');
  if (ixx < 0) return;
  var ftype = fname.slice(ixx + 1);
  ftype = ftype.toLowerCase();
  if (ftype !== 'pbn') return;
  var fpath = item.Path;
  try {
    bc.Open(fpath);
  } catch(ex)
  {
    return;
  }

  var npath = fpath.substr(0, fpath.length - 3) + 'lin';
  if (fso.FileExists(npath)) {
    var str = 'The file ' + npath + ' already exists.' +
      '\n\nDo you wish to overwrite it?';
    var rc = bc.confirm(str);
    if (!rc)
      return;
    
    fso.DeleteFile(npath);
  }

  bc.ExportAsBridgeBaseOnline(npath, LinFormat)
  ++nFind;
}

var bc = GetBC('5.108');
if (WScript.Arguments.length > 0)
  bc.Open(WScript.Arguments.Item(0));  // for dialog positioning

var nFind = 0;
var sh = WScript.CreateObject('Shell.Application');
var fso = WScript.CreateObject('Scripting.FileSystemObject');
var strFldr = bc.BrowseForFolder('PBNtoLIN: Folder to scan');
if (!strFldr)
  WScript.Quit();

var fldr = sh.NameSpace(strFldr);  // convert string path into Folder object
var bSubfolders = bc.confirm('PBNtoLIN: Scan subfolders?', MB_ICONINFORMATION | MB_YESNO | MB_DEFBUTTON2);
bc.progress(BCP_TITLE, 'PBNtoLIN');
var strFind = '';
ScanFolder(fldr);
Exit(0);
