// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  Sometimes bridge documents have player names in all capital letters.
//  This script changes all-caps player names to mixed case.
//
//  Inaccuracies are inevitable. For example, there is no way
//  to know whether DEVRIES should be changed to Devries or DeVries:
//  each particular person has their own preferred spelling.
//  See https://brians.wsu.edu/2016/05/25/multipart-names/.
//
//
//  $Id: NameCase.js 49 2021-05-22 13:24:33Z Ray $


var bModified = false;

//  List of European prepositions and articles ("of" and "the") from
//  https://brians.wsu.edu/2016/05/25/multipart-names/

var vNocap =
[
  'de',
  'da',
  'di',
  'von',
  'van',
  'le',
  'la',
  'du',
  'des',
  'del',
  'della',
  'der',
];

var vNomod =
[
  'II',
  'III',
  'IV',
  'MD',
  'DDS',
];

var mapNocap = {};
var mapNomod = {};

(function()
{
  for (var i in vNocap) {
    var str = vNocap[i];
    mapNocap[str] = true;
  }

  for (var i in vNomod) {
    var str = vNomod[i];
    mapNomod[str] = true;
  }
})();


function CaseName(strName)
{
  var vName = strName.split(' ');
  var strNew = '';
  for (var i in vName) {
    if (i > 0) strNew += ' ';
    var strPart = vName[i];
    var strUpper = strPart.toUpperCase();
    if (strUpper !== strPart || mapNomod[strPart]) {
      strNew += strPart;  // already mixed case, or exception: use as-is
    } else {
      var strLower = strPart.toLowerCase();
      var bCap = (i == 0) || !mapNocap[strLower];
      if (bCap) {
        strNew += strLower.substr(0, 1).toUpperCase();
        strNew += strLower.substr(1);
      } else {
        strNew += strLower;
      }
    }
  }

  return strNew;
}


var vNameTag =
[
  'North', 
  'East', 
  'South', 
  'West',
];

function CaseBoard(bd)
{
  for (var i in vNameTag) {
    var strTag = vNameTag[i];
    var strName = bd.TagValue(strTag);
    var strNew = CaseName(strName);
    if (strNew !== strName) {
      bd.TagValue(strTag) = strNew;
      bModified = true;
    }
  }
}


(function()
{
  var bc = WScript.CreateObject('BridgeComposer.Object');

  if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
    bc.Open(WScript.Arguments(0));
  } else {
    if (!bc.Open()) WScript.Quit();
  }

  var bds = bc.Boards;
  while (bds.MoveNext()) {
    var bd = bds.Current;
    CaseBoard(bd);
  }

  if (bModified)
    bc.Save();
})();
