// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  This script will toggle the BridgeComposer "Diagram position" setting
//  (in "Format>Board Layout", General tab) between "Center" and "Float left".
//  No other layout settings are affected.
//
//  $Id: LayoutFloatLeft.js 52 2021-05-31 14:33:17Z Ray $


var strAppend = '%BCOptions Float';
 
function AdjustLine(line) {
  //  Toggle between Float and Center in the %BCOptions header line.
  //  If neither is present (diagram is left justified), add Float.
  //  For legacy BC files (created before version 5.31.4, released 2012-08-11),
  //  remove %Center and %Float lines, and add an appropriate %BCOptions line.

  var retLine = line;
  var vLine = line.split(' ');
  if (vLine[0] === '%BCOptions') {
    var bFind = false;
    for (var i = 0; i < vLine.length; ++i) {
      if (vLine[i] === 'Float') {
        bFind = true;
        vLine[i] = 'Center';
      } else if (vLine[i] === 'Center') {
        bFind = true;
        vLine[i] = 'Float';
      }
    }

    if (!bFind)
      vLine.push('Float');
    
    retLine = vLine.join(' ');
    strAppend = '';
  } else if (vLine[0] === '%Float') {
    var nFloat = (vLine.length > 1) ? parseInt(vLine[1]) : 0;
    if (nFloat !== 0)
      strAppend = '%BCOptions Center';

    retLine = '';
  } else if (vLine[0] === '%Center') {
    retLine = '';
  }

  return retLine;
}

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0)
	bc.Open(WScript.Arguments.Item(0));
else
  if (!bc.Open()) WScript.Quit();

var fso = WScript.CreateObject('Scripting.FileSystemObject');
var fldrTemp = fso.GetSpecialFolder(2);   // TemporaryFolder
var strTempName = fso.GetTempName();
var pathLayout = fldrTemp + '\\' + strTempName;
var tsLayout = fso.CreateTextFile(pathLayout);

var pathDoc = bc.pathname;
var tsDoc = fso.OpenTextFile(pathDoc, 1);

while (!tsDoc.AtEndOfStream) {
  var line = tsDoc.ReadLine();
  if (line.length === 0 || line.charAt(0) !== '%') break;
  line = AdjustLine(line);
  if (line.length > 0)
    tsLayout.WriteLine(line);
}

if (strAppend.length > 0)
  tsLayout.WriteLine(strAppend);

tsLayout.Close();
tsDoc.Close();
bc.LoadLayout(pathLayout);
bc.Save();
fso.DeleteFile(pathLayout);
