// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script updates the titles in a hand record file received
//  from a third party (such as ACBL or Common Game).
//  The hand record file is formatted like the file
//  BCHRLayout.pbn (in the user's "Documents" folder),
//  which is created the first time this script is run.
//  You may use BridgeComposer to customize BCHRLayout.pbn for your site.
//  Run this script to apply the layout to any hand record file.
//  Revised 2018-09-26

var bc = WScript.CreateObject('BridgeComposer.Object');
var wsh = WScript.CreateObject('WScript.Shell');
var pathDocs = wsh.SpecialFolders('MyDocuments');
var pathLayout= pathDocs + '\\BCHRLayout.pbn';
var fso = WScript.CreateObject('Scripting.FileSystemObject');
if (!fso.FileExists(pathLayout)) {
  var s = bc.prompt('HRTitles.js\nEnter your "Site" title', 'Our Bridge Club');
  if (!s) WScript.Quit();
  var ts = fso.CreateTextFile(pathLayout);
  ts.WriteLine('%BCOptions Center GutterH GutterV STBorder STShade');
  ts.WriteLine('%BoardsPerPage 18');
  ts.WriteLine('%Margins 252,250,250,250');
  ts.WriteLine('%HRTitleSite "' + s + '"');
  ts.Close();
}
bc.Open(pathLayout);
var strSite = bc.Site;
if (WScript.Arguments.length > 0) {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}
var vs = bc.Site.split(' ');
var bcg = vs.length > 0 && vs[0] === 'TheCommonGame.com';
bc.Site = strSite;
if (bcg) {
  var ve = bc.Event.split(' ');
  if (ve.length >= 2) {
    var d = new Date(ve[1]);
    bc.Date = d.getVarDate();
  }
  var s = 'Afternoon';
  if (bc.Event.indexOf('Morn') >= 0)
    s = 'Morning';
  else if (bc.Event.indexOf('Nite') >= 0)
    s = 'Evening';
  bc.Event = s + ' Pairs';
  if (!bc.SetId && ve.length > 2)
    bc.SetId = ve[ve.length - 1];
}
bc.LoadLayout(pathLayout);
bc.Save();
