// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  The BridgeComposer "File>Export As>LIN Classic Format" and
//  "File>Export As>LIN Modern Format" menu commands create LIN files
//  containing the hands, player names, auction, play, and commentary.
//  This script creates a LIN file containing the hands only.

//  $Id: ExportCardsOnlyAsLIN.js 122 2022-11-17 21:55:12Z Ray $

function GetBC(minver)    // copied from BCConst.js
{
  if (minver) {
    if (typeof minver !== 'string')
      throw 'GetBC argument must be a string, because trailing zeros are significant'
  } else {
    minver = '5.61';  // default if "minver" omitted
  }
  
  try {
    var bc = WScript.CreateObject('BridgeComposer.Object');
  } catch (e) {
    WScript.Echo('To run this script, you need to install BridgeComposer ' +
      '(version ' + minver + ' or later).\r\n\r\n' +
      'Visit https://bridgecomposer.com and click "Download Now".');
    WScript.Quit(1);
  }
  
  var arrMin = minver.split('.');
  while (arrMin.length < 3)
    arrMin.push(0);
  
  var arrNow = bc.Version.split('.');
  while (arrNow.length < 3)
    arrNow.push(0);
  
  for (var i = 0; i < 3; ++i) {
    arrMin[i] = parseInt(arrMin[i]);
    arrNow[i] = parseInt(arrNow[i]);
    if (arrNow[i] > arrMin[i])
      break;
    
    if (arrNow[i] < arrMin[i]) {
      WScript.Echo('To run this script, you need to update BridgeComposer ' +
        'to version ' + minver + ' or later.\n\n' +
        'In BridgeComposer, use the "Help>Check For Updates" menu command.');
      WScript.Quit(1);
    }
  }
  
  return bc;
}

function GetDefaultPath(strExtn)
{
  var strPath = bc.CallerPathname;
  if (!strPath)
    strPath = bc.pathname;
  
  var ix = strPath.lastIndexOf('.');
  if (ix < 0)
    return '';    // no period
    
  var jx = strPath.indexOf('\\', ix);
  if (jx >= 0)
    return '';    // a backslash follows the last period
  
  strPath = strPath.substr(0, ix + 1);  // remove old extension
  strPath += strExtn;   // append new extension
  return strPath;
}

//  main program

var bc = GetBC('5.86');
if (WScript.Arguments.length > 0) {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

//	create a cards-only copy of the input file

var arTag = [
	'Board',
	'Dealer',
	'Vulnerable',
	'Deal',
];

var bcx = WScript.CreateObject('BridgeComposer.Object');
var bds = bc.Boards;
while (bds.MoveNext()) {
  var bd = bds.Current;
  var bdx = bcx.NewBoard();
  for (ix in arTag) {
    var s = arTag[ix];
    bdx.TagValue(s) = bd.TagValue(s);
  }
}

//  export the copy to a LIN file

var pathDefault = GetDefaultPath('lin');
//  BrowseForFile: call via bc (not bcx) to set dialog parent window correctly
var pathExport = bc.BrowseForFile('Export Cards Only', 1,
  'Bridge Base Online Document (*.lin)|*.lin||', pathDefault);
  
if (!pathExport)
  WScript.Quit();

bcx.ExportAsBridgeBaseOnline(pathExport);
