// This script file is licensed under a Creative Commons 
// Attribution 4.0 International License (cc by 4.0): 
// http://creativecommons.org/licenses/by/4.0/ 
// You may adapt and/or share this script file for any purpose, 
// provided you give credit to http://bridgecomposer.com 

// This script prompts for a PBN file and finds the boards in it, where NS lost more than 10 Imp 
// It then prompts for a new file in which to save those

//  $Id: ExportBad.js 228 2025-05-19 01:03:35Z Ray $

 var arCopy = ['Event', 'Site', 'Date', 'Board', 'Dealer', 'Vulnerable', 'Deal', 'Scoring'];
 var nSelect = -1;
 function resetBoard(bd) 
 { 
  var bnew = bc.NewBoard();
  for (var iTag in arCopy) {
    var strTagname = arCopy[iTag];
    bnew.TagValue(strTagname) = bd.TagValue(strTagname);
  }
  return bnew
 }
 var out = WScript.CreateObject('BridgeComposer.Object');
 var bc = WScript.CreateObject('BridgeComposer.Object');
 if (WScript.Arguments.length > 0) {
    bc.Open(WScript.Arguments(0));
 } else {
   if (!bc.Open()) WScript.Quit();
 }
  var bds = bc.Boards;
  var s = '';
  var prevBoard = null;
  for (var i = 0; i < bds.Count; ++i) {
    var b = bds.Item(i); 
    // skipping every second boards, expecting boards to be ordered
    var currentBoardValue = b.TagValue('Board');
    if (prevBoard != currentBoardValue) {
      var scoreIMP = b.TagValue('ScoreIMP'); // Example: "NS 11.00"
      var scoreParts = scoreIMP.split(' '); // Split by space
      var scoreValue = parseFloat(scoreParts[1]); // Extract the numeric part 
      //WScript.Echo(scoreValue, scoreParts[1], scoreParts[0]);
      if (!isNaN(scoreValue) && ((scoreValue < -10 && scoreParts[0] == "NS")
        || (scoreValue > 10 && scoreParts[0] == "EW"))) {
        s += ' ' + b.TagValue('Board')
        var new_board = resetBoard(b)
        var pbn = new_board.toPbn()
        out.ParsePbn(pbn);
      }
      prevBoard = currentBoardValue
    }
  }
  if (s.length == 0) {
    WScript.Echo('No bad boards found');
  } else {
    WScript.Echo('Huge IMP loss on boards:\n', s);
    out.Save();
  }
  // Other might find use for a popup asking for threshold and side, but this solve my problem.

