// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  Sets all the show/hide controls to "show" in all boards of a document.

//  $Id: ExpandAll.js 24 2021-04-24 22:45:23Z Ray $

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

var bds = bc.Boards;
while (bds.MoveNext())
{
  var bd = bds.Current;
  var flags = parseInt(bd.TagValue('BCFlags'), 16);
  flags |= 0xff;
  bd.TagValue('BCFlags') = flags.toString(16);
}

bc.Save();
