// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
// $Id: Executor.js 160 2023-09-21 09:52:54Z Ray $
//
//  "Tag Value Inheritance", using leading # and ## (hash) characters in tag values,
//  is described in the PBN standard, version 2.1, section 4.8.
//
//  This script explicitly assigns PBN tags in all boards their "inherited" values
//  and removes the hash notation.
//
//  If boards are going to be added to the document, and/or the existing boards are
//  going to be reordered, then tags that inherit a value may end up inheriting from
//  a different board, and thus display a different value.
//  Running this script beforehand will ensure that this doesn't happen.
//
//  The standard says inheritance applies to all tags except
//  Dealer, Vulnerable, Deal, Declarer, Contract, Auction, Play, and Note;
//  but we adjust only the tags listed in the "vTag" array (below).
//  Feel free to add additional tags to vTag if you like.

var vTag = [
  'Event',
  'North',
  'East',
  'South',
  'West',
];

var bc = WScript.CreateObject('BridgeComposer.Object');

(function()
{
  var map1 = {};
  var map2 = {};

  if (WScript.Arguments.length > 0 && WScript.Arguments.Item(0) != '-')
    bc.Open(WScript.Arguments.Item(0));
  else
    if (!bc.Open())
      WScript.Quit();

  var bds = bc.Boards;
  while (bds.MoveNext()) {
    var bd = bds.Current;
    for (var ix in vTag) {
      var tag = vTag[ix];
      var strValueIn = bd.TagValue(tag);
      var strValue = strValueIn;
      var strMap1 = map1[tag];
      var strMap2 = map2[tag];
      if (strValue.substr(0, 2) === '##') {

        // ##[text]
        strValue = strValue.substr(2);
        map1[tag] = strValue;
        map2[tag] = strValue;
      } else if (strValue === '#') {

        // #
        if (strMap1 !== undefined)
          strValue = strMap1;
        else
          strValue = '';
      } else {

        // [text]
        map1[tag] = strValue;
        if (strValue.length > 0) {
          // <non-empty>

          // Today I think the standard says the following,
          // but currently BridgeComposer (5.104.1) does not.
          // if (strMap2 !== undefined)
          //   map2[tag] = strValue;

          //  This emulates current BridgeComposer behavior (5.104.1)
          map2[tag] = undefined;

        } else {
          // <empty>
          if (strMap2 !== undefined)
            strValue = strMap2;
        }
      }

      if (strValue !== strValueIn)
        bd.TagValue(tag) = strValue;
    }
  }

  bc.Save();
})();
