// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  When boards are played more than once, sometimes we get a file
//  with multiple instances of each board, each scored individually.
//  This script creates a new instance of each board, and adds to it a
//  Score Table that summarizes all the results for the board.
//  These new instances are appended to the end of the document.
//
//  This script is designed to run from the BridgeComposer "Script" menu.
//  
//  $Id: CombineScores.js 217 2024-11-12 12:53:42Z Ray $


function FormatData(str)
{
  if (str.length == 0)
    return '-';
  
  if (str.indexOf(' ') >= 0)
    return '"' + str + '"';
  
  return str;
}

function GetData(bd)
{
  //  Contract

  var strContract = bd.TagValue('Contract');
  var strData = FormatData(strContract);
  
  //  Declarer
  var strDeclarer = bd.TagValue('Declarer');
  strData += ' ' + FormatData(strDeclarer);

  //  Play (first card)
  
  var strPlay = bd.TagSection('Play');
  var arPlay = strPlay.split(' ');
  var strLead = (arPlay.length > 0) ? arPlay[0] : '';
  strData += ' ' + FormatData(strLead);

  //  Result
  
  var strResult = bd.TagValue('Result');
  strData += ' ' + FormatData(strResult);

  //  Score_NS, Score_EW

  var strScore = bd.TagValue('Score');
  var arScore = strScore.split(' ');
  var nScore = 0;
  if (arScore.length === 1) {
    nScore = parseInt(arScore[0]);
    if (strDeclarer === 'E' || strDeclarer === 'W')
      nScore = -nScore;
  } else if (arScore.length === 2) {
    nScore = parseInt(arScore[1]);
    if (arScore[0] === 'EW')
      nScore = -nScore;
  }
  
  if (nScore > 0)
    strData += ' ' + nScore + ' -';
  else if (nScore < 0)
    strData += ' - ' + -nScore;
  else
    strData += ' - -';

  //  MP_NS, MP_EW
  
  var strMP = bd.TagValue('ScoreMP');
  var arMP = strMP.split(' ');
  if (arMP.length === 4 && arMP[0] === 'NS' && arMP[2] === 'EW') {
    strData += ' ' + FormatData(arMP[1]) + ' ' + FormatData(arMP[3]);
  } else {
    strData += ' - -';
  }

  //  Names_NS, Names_EW
  
  var strNS = bd.TagValue('North') + '-' + bd.TagValue('South');
  strData += ' ' + FormatData(strNS);
  
  var strEW = bd.TagValue('East') + '-' + bd.TagValue('West');
  strData += ' ' + FormatData(strEW);

  strData += '\r\n';
  return strData; 
}

var arCopy = ['Event', 'Site', 'Date', 'Board',
  'Dealer', 'Vulnerable', 'Deal', 'Scoring'];
  
  var nSelect = -1;
  
function Combine(iFirst, iLimit)
{
  if (iFirst < 0)
    return;
  
  var strSection = '';  
  for (var ix = iFirst; ix < iLimit; ++ix) {
    var bd = bc.Boards.Item(ix);
    strSection += GetData(bd);
  }
  
  if (nSelect < 0)
    nSelect = bc.Boards.Count;
  
  var bnew = bc.NewBoard();
  for (var iTag in arCopy) {
    var strTagname = arCopy[iTag];
    bnew.TagValue(strTagname) = bd.TagValue(strTagname);
  }
    
  bnew.TagValue('ScoreTable') =
    'Contract;Declarer;Lead;Result;Score_NS;Score_EW;MP_NS;MP_EW;Names_NS;Names_EW';
  
  bnew.TagSection('ScoreTable') = strSection;
}

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0)
  bc.Open(WScript.Arguments.Item(0));

var lastBoard = '';
var lastDeal = '';
var lastIndex = -1;
var cBoards = bc.Boards.Count;
for (var iBoard = 0; iBoard < cBoards; ++iBoard)
{
  var bd = bc.Boards.Item(iBoard);
  if (bd.TagValue('Board') !== lastBoard ||
  bd.TagValue('Deal') !== lastDeal) {
    Combine(lastIndex, iBoard);
    lastBoard = bd.TagValue('Board');
    lastDeal = bd.TagValue('Deal');
    lastIndex = iBoard;
  }
}

Combine(lastIndex, iBoard);

if (nSelect >= 0)
  bc.SelectedBoard = nSelect;

bc.Save();
