// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script removes the double-dummy information from all boards
//  in a document. When added to the BridgeComposer Script menu,
//  this may may be more convenient than using the BridgeComposer
//  Tools>All Boards, Board>Clear commands.

//  $Id: ClearDoubleDummy.js 141 2023-07-12 12:48:22Z Ray $

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0)
  bc.Open(WScript.Arguments(0));
else
  if (!bc.Open()) WScript.Quit();

var bds = bc.Boards;
while (bds.MoveNext()) {
  var bd = bds.Current;
  bd.ClearTag('DoubleDummyTricks');
  bd.ClearTag('OptimumResultTable');
  bd.ClearTag('OptimumScore');
  bd.ClearTag('ParContract');
  bd.ClearTag('OptimumOpeningLeadTable');
}

bc.Save();
