// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script adjusts Vulnerability on all boards for Chicago-style play.
//  The dealer is standard: Board 1 dealer is North and it rotates clockwise.
//  The Vulnerability rotates None, dealer side, dealer side, Both, in that order for each four boards.
//  You may specify the "a" argument for the alternate vulnerability rotation that some prefer:
//  None, non-dealer side, non-dealer side, Both.
//
//  $Id: ChicagoVul.js 85 2022-03-27 21:35:30Z Ray $

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

var vVul = ['None', 'EW', 'NS', 'All'];
if (WScript.Arguments.length > 1 && WScript.Arguments(1) == 'a')
  vVul = ['None', 'NS', 'EW', 'All'];

var nDealer = 0;
var bds = bc.Boards;
while (bds.MoveNext())
{
  var bd = bds.Current;
  bd.TagValue('Vulnerable') = vVul[nDealer];
  nDealer = (nDealer + 1) & 3;
}

bc.Save();
