// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  These script functions filter random boards and select those
//  that meet certain criteria.
//
//  Revised 2021-01-30

//  This file is included by ..\CreateDealType.wsf.
//  It is not designed to be run stand-alone.


DefineFilter(CDT1, 'Opening Hands', 'Reverse',
function()
{
  var PASS = -1, NOTRUMP = 4, OTHER = 5;
  function NResp(bid)
  {
    //  Returns the type of response North will likely make to South's bid
    //  of 1 in a suit, assuming West passes
    if (N.hcp < 6) return PASS;
    if (bid <= HEARTS && N.suit[bid].length >= 3) return bid;  // major suit raise
    var L1 = -1, s1;
    //  look up the line
    for (var iSuit = bid - 1; iSuit >= 0; --iSuit) {
      if (N.suit[iSuit].length > L1) {
        s1 = iSuit;
        L1 = N.suit[iSuit].length;
      }
    }
    if (L1 >= 4) return s1; // one-over-one (DIAMS(2), HEARTS(1), or SPADES(0))
    if (N.hcp < 10) return NOTRUMP; // 1NT or perhaps minor suit raise
    return OTHER; // something else: forcing 1NT, two over one, ...
  }
  
  if (!EWPassing()) return false;
  if (S.hcp < 17) return false;
  if (LTC(S) <= 4) return false;  // likely open 2C
  // find longest suit
  var L1 = -1, s1;
  for (var iSuit = 0; iSuit < NSUITS; ++iSuit) {
    if (S.suit[iSuit].length > L1) {
      s1 = iSuit;
      L1 = S.suit[iSuit].length;
    }
  }
  // find 2nd longest suit
  var L2 = -1, s2;
  for (var iSuit = 0; iSuit < NSUITS; ++iSuit) {
    if (iSuit !== s1) {
      if (S.suit[iSuit].length > L2) {
        s2 = iSuit;
        L2 = S.suit[iSuit].length;
      }
    }
  }
  
  if (L2 < 4) return false; // 2nd suit too short
  if (L2 === L1) return false;  // equal-length suits
  if (s2 > s1) return false;  // 2nd suit lower-ranking
  if (S.hcp >= 20) {
    // check for possible 2NT opener (or 2C opener with NT rebid)
    for (var iSuit = SPADES; iSuit <= HEARTS; ++iSuit) {
      if (S.suit[iSuit].length !== 2) break;
      if (!S.hasCard2(iSuit, RANK_A) && !S.hasCard2(iSuit, RANK_K)) break;
    }
    if (iSuit > HEARTS) return false; // might open 2NT, or open 2C and rebid NT
  }
  var nr = NResp(s1);
  if (nr === PASS) return false; // N passes
  if (nr === s1 || nr === s2) return false; // N raises or bids my 2nd suit
  if (nr < NOTRUMP && nr > s2) return false;  // would rebid up-the-line
  if (nr !== SPADES && S.hasCard('SA')) return false; // might rebid 2NT
  if (nr !== HEARTS && S.hasCard('HA')) return false; // might rebid 2NT
  strAuction = '1' + deal_strSuit.charAt(s1);
  return true;
});


DefineFilter(CDT1 + CDTDDA, 'Long Search', 'Only one makeable contract',
function()
{
  // only one makeable contract
  var cMake = 0;
  for (var i = 0; i < 20; ++i) {
    var ch = DDA.charAt(i);
    var n = parseInt(ch, 16);
    if (n > 6) {
      ++cMake;
      if (cMake > 1)
        return false;
    }
  }
  
  if (cMake !== 1)
    return false;
  
  strCmtyFinal = CDTStatus(true);
  return true;
});


function rlsBothMakeNT(level)
{
  var nsmake = DDA.charAt(0) === level || DDA.charAt(5) === level;
  if (!nsmake) return false;
  
  var ewmake = DDA.charAt(10) === level || DDA.charAt(15) === level;
  if (!ewmake) return false;
  
  strCmtyFinal = CDTStatus(true);
  return true;
}


DefineFilter(CDT1 + CDTDDA, 'Long Search', 'Both sides make 1NT',
function()
{
  var bMake = rlsBothMakeNT('7');
  if (!bMake)
    return false;
  
  for (var i = 0; i < 20; ++i) {
    var strMake = DDA.charAt(i);
    var nMake = parseInt(strMake, 16);
    if (nMake > 7)
      return false;   // someone can make more than 1NT
  }
  
  return true;
});


DefineFilter(CDT1 + CDTDDA, 'Long Search', 'Both sides make 7NT',
function()
{
  return rlsBothMakeNT('d');
});


function rlsFilterLength(nFilter)
{
  for (var iHand = 0; iHand < NHANDS; ++iHand) {
    for (var iSuit = 0; iSuit < NSUITS; ++iSuit) {
      var nLength = deal.hand[iHand].suit[iSuit].length;
      if (nLength >= nFilter) {
        strCmtyFinal = CDTStatus(true);
        return true;
      }
    }
  }
  return false;
}


DefineFilter(CDT1 + CDTDDA, 'Long Search', 'Par Zero Deal',
function()
{
  for (var i = 0; i < 20; ++i) {
    var strMake = DDA.charAt(i);
    var nMake = parseInt(strMake, 16);
    if (nMake > 6)
      return false;
  }
  
  return true;
});

DefineFilter(CDT1, 'Misc', '9+ card suit',
function()
{
  return rlsFilterLength(9);
});


DefineFilter(CDT1, 'Misc', '10+ card suit',
function()
{
  return rlsFilterLength(10);
});
