// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com
//
//  Revised 3/26/2019

//  This file is included by ..\CreateDealType.wsf.
//  It is not designed to be run stand-alone.


DefineFilter(CDT2, 'Weak 1NT Opener', 'Game-Going or Better Stayman Response',
function()
{
// Weak 1NT opener, game-going or better Stayman response
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 14) return false;     // West not 12-14 HCP
  if (E.hcp < 13) return false; // East has less than game values
  if (!W.isBalanced()) return false;  // West not balanced
  if (W.suit[SPADES].length > 4) return false;
  if (W.suit[HEARTS].length > 4) return false;
  if (E.suit[SPADES].length >= 5
    || E.suit[HEARTS].length >= 5) return false; // East has a 5-card major
    
  if (E.suit[SPADES].length != 4 && E.suit[HEARTS].length != 4) return false;	// East has no 4-card major
  return true;
});


DefineFilter(CDT2, 'Weak 1NT Opener', 'Invitational or Better Stayman Response',
function()
{
// Weak 1NT opener, invitational or better Stayman response
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 14) return false;     // West not 12-14 HCP
  if (E.hcp < 11) return false; // East has less than 11 HCP
  if (!W.isBalanced()) return false;  // West not balanced
  if (W.suit[SPADES].length > 4) return false;
  if (W.suit[HEARTS].length > 4) return false;
    
  if (E.suit[SPADES].length != 4 && E.suit[HEARTS].length != 4) return false;	// East has no 4-card major
  return true;
});


DefineFilter(CDT2, 'Weak 1NT Opener', 'Red Suit Transfer Response',
function()
{
// Weak 1NT opener, Red suit transfer response
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 19) return false;     // West not 15-17 HCP
  if (!W.isBalanced()) return false;  // West not balanced
  if (W.suit[SPADES].length >= 5
    || W.suit[HEARTS].length >= 5) return false; // West has a 5-card major
  if (E.suit[SPADES].length < 5 && E.suit[HEARTS].length < 5) return false;	// East has no 5-card major
  return true;
});


DefineFilter(CDT2, 'Strong 2NT Opener', 'Invitational or Better Stayman Response',
function()
{
// Strong 2NT opener, invitational or better Stayman response
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 19 || W.hcp > 22) return false;     // South not 19-22 HCP
  if (!W.isBalanced()) return false;
  if (E.hcp < 4 || E.hcp > 8) return false; // East not 4-8 HCP
  if (E.suit[SPADES].length != 4 && E.suit[HEARTS].length != 4) return false;	// East has no 4-card major
  return true;
});


DefineFilter(CDT2, 'Opening Hands', 'Balanced 15-19 HCP',
function()
{
// Balanced opening hand 15-19
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 15 || W.hcp > 19) return false;     // West not 15-19 HCP
  if (W.suit[SPADES].length >= 5
    || W.suit[HEARTS].length >= 5) return false; // West has a 5-card major
   if (E.hcp < 6) return false; // East has less than 6 HCP
  if (!W.isBalanced()) return false;  // WEST not balanced
  return true;
});


DefineFilter(CDT2, 'Opening Hands', '15-19 HCP',
function()
{
// Reverse bids
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 15 || W.hcp > 19) return false;
  return true;
});


DefineFilter(CDT2, 'Strong Opener', '23+ HCP',
function()
{
// 23+ hands
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 23) return false;     // West not 23 plus
  return true;
});


DefineFilter(CDT2, 'Strong Opener', 'Strong Two Bid',
function()
{
// Strong Two hands
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 20 || W.hcp > 22) return false;     // West not 20-22 HCP
  if (W.suit[SPADES].length > 5 && W.suit[SPADES].hcp > 4) return true;
  if (W.suit[HEARTS].length > 5 && W.suit[HEARTS].hcp > 4) return true;
  if (W.suit[DIAMS].length > 5 && W.suit[DIAMS].hcp > 4) return true;
  return false;
});


DefineFilter(CDT2, 'RHO Opens a Weak 1NT', 'Rule of 8',
function()
{
// Weak 1NT opener, Rule of Eight
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 14) return false;     // West not 12-14 HCP
  if (W.suit[SPADES].length >= 5 
    || W.suit[HEARTS].length >= 5) return false; // West has a 5-card major
   
  if (N.hcp < 7) return false; //North has too few points
  if (N.hcp > 14) return false; //North would Double
  if (N.suit[SPADES].length > 3 && N.suit[HEARTS].length > 4) return true; //Spades and HEARTS
  if (N.suit[SPADES].length > 3 && N.suit[DIAMS].length > 4) return true; 
  if (N.suit[SPADES].length > 3 && N.suit[CLUBS].length > 4) return true;
  if (N.suit[HEARTS].length > 3 && N.suit[DIAMS].length > 4) return true; 		 
  if (N.suit[HEARTS].length > 3 && N.suit[CLUBS].length > 4) return true; 
  if (N.suit[DIAMS].length > 3 && N.suit[CLUBS].length > 4) return true;
  return false;
});


DefineFilter(CDT2, 'Preempts', 'Good Quality Three Level Preempt',
function()
{
// West has good quality three level preempt
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp > 9) return false;     // West more than 9 HCP
  if (W.suit[SPADES].length == 7 && W.suit[SPADES].hcp > 5) return true;
  if (W.suit[HEARTS].length == 7 && W.suit[HEARTS].hcp > 5) return true;
  if (W.suit[DIAMS].length == 7 && W.suit[DIAMS].hcp > 5) return true;
  if (W.suit[CLUBS].length == 7 && W.suit[CLUBS].hcp > 5) return true;
  return false;
});


DefineFilter(CDT2, 'RHO Opens a Weak 1NT', 'Penalty Double',
function()
{
// Weak 1NT opener, Penalty Double
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 14) return false;     // West not 12-14 HCP
  if (N.hcp < 15) return false; // North has less than 15 HCP
  if (!W.isBalanced()) return false;  // West not balanced
  if (W.suit[SPADES].length > 4) return false;
  if (W.suit[HEARTS].length > 4) return false;
  return true;
});


DefineFilter(CDT2, 'Opening Hands', '4-4-4-1 Shape',
function()
{
// West opening hand 4441 shape
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 13) return false;     // West not 12-13 HCP
  if (W.suit[SPADES].length == 4 && W.suit[HEARTS].length == 4 && W.suit[DIAMS].length == 4) return true; //Spades, hearts and diamonds
  if (W.suit[HEARTS].length == 4 && W.suit[DIAMS].length == 4 && W.suit[CLUBS].length == 4) return true; //hearts,diamonds and clubs
  if (W.suit[CLUBS].length == 4 && W.suit[HEARTS].length == 4 && W.suit[SPADES].length == 4) return true; //clubs,hearts and sapdes
  if (W.suit[CLUBS].length == 4 && W.suit[DIAMS].length == 4 && W.suit[SPADES].length == 4) return true; //clubs,diamonds and sapdes
  return false;
});
  

DefineFilter(CDT2, 'Opening Hands', 'Light In Third Seat',
function()
{
// West light opener in the third seat
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  dealer = EAST;
  if (E.hcp < 10 && S.hcp < 11 && (W.hcp < 12 && W.hcp > 9) && (!W.isBalanced())) return true;
  return false;
});


DefineFilter(CDT2, 'Opening Hands', '4-3-3-3 Shape',
function()
{
// West opening hand 4333 shape
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 12 || W.hcp > 14) return false;     // West not 12-14 HCP
  if (W.suit[SPADES].length == 4 && W.suit[HEARTS].length == 3 && W.suit[DIAMS].length == 3 && (E.isBalanced())) return true; //Spades, hearts and diamonds
   if (W.suit[HEARTS].length == 4 && W.suit[DIAMS].length == 3 && W.suit[CLUBS].length == 3 && (E.isBalanced())) return true; //hearts,diamonds and clubs
  if (W.suit[CLUBS].length == 4 && W.suit[HEARTS].length == 3 && W.suit[SPADES].length == 3 && (E.isBalanced())) return true; //clubs,hearts and sapdes
  if (W.suit[CLUBS].length == 4 && W.suit[DIAMS].length == 3 && W.suit[SPADES].length == 3 && (E.isBalanced())) return true; //clubs,diamonds and sapdes
  return false;
});


DefineFilter(CDT2, 'Preempts', 'Weak Two Opener, Ogust Response',
function()
{
// Weak Two hands Ogust Enquiry
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp > 10) return false;
  if (E.hcp < 16 || E.hcp > 19) return false;
  if (W.suit[SPADES].length == 6 && W.suit[SPADES].hcp > 4) return true;
  if (W.suit[HEARTS].length == 6 && W.suit[HEARTS].hcp > 4) return true;
  return false;
});


DefineFilter(CDT2, 'RHO Opens One of a Suit', 'Ghestem, CRO, Michaels, and Unusual 2NT',
function()
{
// South opening hand West has two suited overcall
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  dealer = SOUTH;
  if (S.hcp < 12 || S.hcp > 19) return false;
  if (S.isBalanced()) return false; 
  if (W.suit[SPADES].length > 4 && W.suit[HEARTS].length > 4) return true;
  if (W.suit[SPADES].length > 4 && W.suit[DIAMS].length > 4) return true; 
  if (W.suit[SPADES].length > 4 && W.suit[CLUBS].length > 4) return true;
  if (W.suit[HEARTS].length > 4 && W.suit[DIAMS].length > 4) return true; 		 
  if (W.suit[HEARTS].length > 4 && W.suit[CLUBS].length > 4) return true; 
  if (W.suit[DIAMS].length > 4 && W.suit[CLUBS].length > 4) return true; 
  return false;
});


DefineFilter(CDT2, 'Opening Hands', 'Rule of 20',
function()
{
// West opening on Rule of 20
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 11 || W.hcp > 11) return false;     // West not 11
  if (W.suit[SPADES].length == 5 && W.suit[HEARTS].length > 3) return true; //5Spades, 4hearts 
  if (W.suit[SPADES].length == 5 && W.suit[DIAMS].length > 3) return true; //5Spades, 4Diamonds 
  if (W.suit[SPADES].length == 5 && W.suit[CLUBS].length > 3)  return true; //5Spades, 4 Clubs
  if (W.suit[HEARTS].length == 5 && W.suit[SPADES].length > 3) return true; //hearts & spades
  if (W.suit[HEARTS].length == 5 && W.suit[HEARTS] > 3) return true; //hearts & diamonds
  if (W.suit[HEARTS].length == 5 && W.suit[HEARTS] > 3) return true; //hearts & clubs
  if (W.suit[DIAMS].length == 5 && W.suit[SPADES].length > 3) return true; //diamonds & spades
  if (W.suit[DIAMS].length == 5 && W.suit[HEARTS].length > 3) return true; //diamonds & Hearts
  if (W.suit[CLUBS].length == 5 && W.suit[SPADES].length > 3) return true; //clubs & spades
  if (W.suit[CLUBS].length == 5 && W.suit[HEARTS].length > 3) return true; //clubs & hearts	
  if (W.suit[CLUBS].length == 5 && W.suit[DIAMS].length > 3) return true; //clubs & diamonds
  return false;
});


DefineFilter(CDT2, 'Slam Bidding', 'Exploring Slam Hands',
function()
{  
// Exploring Slam hands
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 15 || W.hcp > 19) return false;
  if (E.hcp < 12) return false;
  return true;
});


DefineFilter(CDT2, 'RHO Opens a Weak 1NT', 'Landy',
function()
{
// Weak 1NT opener, Landy overcall
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  dealer = SOUTH;
  if (S.hcp < 12 || S.hcp > 14) return false;     // South not 12-14 HCP
  if (S.suit[SPADES].length >= 5
    || S.suit[HEARTS].length >= 5) return false; // South has a 5-card major
  if (!S.isBalanced()) return false; 
  if (W.hcp < 9 || W.hcp > 13) return false;
  if (W.suit[SPADES].hcp < 3 || W.suit[HEARTS].hcp < 3) return false;
  if (W.suit[SPADES].length > 3 && W.suit[HEARTS].length > 4) return true;
  if (W.suit[SPADES].length > 4 && W.suit[HEARTS].length > 3) return true; 

  return false;
});


DefineFilter(CDT2, 'Slam Bidding', 'Cue Bid to Slam',
function()
{
// Cue Bid to Slam 
// Addition by Keith Butler. Cardiff Bridge Tutors. http://www.bridgewebs.com/lisvaneimprovers
  if (W.hcp < 16 || W.hcp > 19) return false;     // West is 16-19 HCP East < 12
  if (E.hcp < 12) return false; // East has 
  if ((E.suit[SPADES].length > 1) && (E.suit[HEARTS].length > 1) && (E.suit[DIAMS].length > 1) && (E.suit[CLUBS].length > 2)) return false;

  return true;
});
