// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  Check a PBN file for Auction or Play "Notes" that exceed 128 characters.
//  Such notes will cause an export to LIN format to fail when BFC is used for conversion.
//  As of version 5.86, BridgeComposer automatically checks for this before BFC is used.
//  However, as of version 5.98, NetBridgeVu may be used instead of BFC, and this
//  script may be used to find "Notes" that will be truncated.

//  $Id: BFCcheck.js 112 2022-09-16 01:13:51Z Ray $

var nSelect = -1;
var iBoard = 0;

function Exit()
{
  if (nSelect >= 0) {
    bc.SelectedBoard = nSelect;
    bc.Save();
  }

  WScript.Quit(0);
}

function CheckNotes(bd, nSection)
{
  var notes = (nSection) ? bd.PlayNotes : bd.AuctionNotes;
  while (notes.MoveNext()) {
    var strNote = notes.Current.value;
    if (strNote.length > 128) {
      if (nSelect < 0)
        nSelect = iBoard;

      var strMsg = 'Board ' + bd.UniqueBoard + ': ' + ((nSection) ? 'Play' : 'Auction') +
      ' Note "' + strNote.substr(0, 20) + '..." is ' + strNote.length +
      ' characters long,\nexceeding the BFC maximum of 128 characters';

      if (!bc.confirm(strMsg, 16))
        Exit();
    }
  }
}

var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0 && WScript.Arguments(0) !== '-') {
  bc.Open(WScript.Arguments(0));
} else {
  if (!bc.Open()) WScript.Quit();
}

var bds = bc.Boards;
while (bds.MoveNext()) {
  var bd = bds.Current;
  CheckNotes(bd, 0);
  CheckNotes(bd, 1);
  ++iBoard;
}

if (nSelect < 0)
  bc.alert("BFCcheck: No problems found", 64);

Exit();
