// This script file is licensed under a Creative Commons
// Attribution 4.0 International License (cc by 4.0):
// http://creativecommons.org/licenses/by/4.0/
// You may adapt and/or share this script file for any purpose,
// provided you give credit to http://bridgecomposer.com

//  This script anonymizes a PBN file by replacing certain fields
//  in every board:
//    Site, Event: fixed strings (see code for the fixed values)
//    Date: current date
//    West, North, East, South: random surnames from a built-in list
//    (Each unique player name in the input file is always replaced with
//    the same new name. But note that empty player name fields
//    are left empty.)

//  $Id: Anonymize.js 229 2025-05-19 01:35:04Z Ray $


var MB_ICONERROR = 16;


var bc = WScript.CreateObject('BridgeComposer.Object');
if (WScript.Arguments.length > 0) {
  var str = WScript.Arguments.Item(0);
  if (str !== '-')
    bc.Open(str);  // for dialog window positioning
  else
    bc.Open();
}


function Pad(v)
{
  if (v < 10)
    return '0' + v;

  return '' + v;
}


function Shuffle(array)
{
  for (var i = array.length - 1; i > 0; i--) {
      var j = Math.floor(Math.random() * (i + 1));
      var e = array[i];
      array[i] = array[j];
      array[j] = e;
  }
}


var vNameTag = ['West', 'North', 'East', 'South'];
var mapName = {};

//  Adapted from https://www.census.gov/topics/population/genealogy/data/2010_surnames.html
var vName = [
	"Smith",
	"Johnson",
	"Williams",
	"Brown",
	"Jones",
	"Garcia",
	"Miller",
	"Davis",
	"Rodriguez",
	"Martinez",
	"Hernandez",
	"Lopez",
	"Gonzalez",
	"Wilson",
	"Anderson",
	"Thomas",
	"Taylor",
	"Moore",
	"Jackson",
	"Martin",
	"Lee",
	"Perez",
	"Thompson",
	"White",
	"Harris",
	"Sanchez",
	"Clark",
	"Ramirez",
	"Lewis",
	"Robinson",
	"Walker",
	"Young",
	"Allen",
	"King",
	"Wright",
	"Scott",
	"Torres",
	"Nguyen",
	"Hill",
	"Flores",
	"Green",
	"Adams",
	"Nelson",
	"Baker",
	"Hall",
	"Rivera",
	"Campbell",
	"Mitchell",
	"Carter",
	"Roberts",
	"Gomez",
	"Phillips",
	"Evans",
	"Turner",
	"Diaz",
	"Parker",
	"Cruz",
	"Edwards",
	"Collins",
	"Reyes",
	"Stewart",
	"Morris",
	"Morales",
	"Murphy",
	"Cook",
	"Rogers",
	"Gutierrez",
	"Ortiz",
	"Morgan",
	"Cooper",
	"Peterson",
	"Bailey",
	"Reed",
	"Kelly",
	"Howard",
	"Ramos",
	"Kim",
	"Cox",
	"Ward",
	"Richardson",
	"Watson",
	"Brooks",
	"Chavez",
	"Wood",
	"James",
	"Bennett",
	"Gray",
	"Mendoza",
	"Ruiz",
	"Hughes",
	"Price",
	"Alvarez",
	"Castillo",
	"Sanders",
	"Patel",
	"Myers",
	"Long",
	"Ross",
	"Foster",
	"Jimenez",
	"Powell",
	"Jenkins",
	"Perry",
	"Russell",
	"Sullivan",
	"Bell",
	"Coleman",
	"Butler",
	"Henderson",
	"Barnes",
	"Gonzales",
	"Fisher",
	"Vasquez",
	"Simmons",
	"Romero",
	"Jordan",
	"Patterson",
	"Alexander",
	"Hamilton",
	"Graham",
	"Reynolds",
	"Griffin",
	"Wallace",
	"Moreno",
	"West",
	"Cole",
	"Hayes",
	"Bryant",
	"Herrera",
	"Gibson",
	"Ellis",
	"Tran",
	"Medina",
	"Aguilar",
	"Stevens",
	"Murray",
	"Ford",
	"Castro",
	"Marshall",
	"Owens",
	"Harrison",
	"Fernandez",
	"McDonald",
	"Woods",
	"Washington",
	"Kennedy",
	"Wells",
	"Vargas",
	"Henry",
	"Chen",
	"Freeman",
	"Webb",
	"Tucker",
	"Guzman",
	"Burns",
	"Crawford",
	"Olson",
	"Simpson",
	"Porter",
	"Hunter",
	"Gordon",
	"Mendez",
	"Silva",
	"Shaw",
	"Snyder",
	"Mason",
	"Dixon",
	"Munoz",
	"Hunt",
	"Hicks",
	"Holmes",
	"Palmer",
	"Wagner",
	"Black",
	"Robertson",
	"Boyd",
	"Rose",
	"Stone",
	"Salazar",
	"Fox",
	"Warren",
	"Mills",
	"Meyer",
	"Rice",
	"Schmidt",
	"Garza",
	"Daniels",
	"Ferguson",
	"Nichols",
	"Stephens",
	"Soto",
	"Weaver",
	"Ryan",
	"Gardner",
	"Payne",
	"Grant",
	"Dunn",
	"Kelley",
	"Spencer",
	"Hawkins",
	"Arnold",
	"Pierce",
	"Vazquez",
	"Hansen",
	"Peters",
	"Santos",
	"Hart",
	"Bradley",
	"Knight",
	"Elliott",
	"Cunningham",
	"Duncan",
	"Armstrong",
	"Hudson",
	"Carroll",
	"Lane",
	"Riley",
	"Andrews",
	"Alvarado",
	"Ray",
	"Delgado",
	"Berry",
	"Perkins",
	"Hoffman",
	"Johnston",
	"Matthews",
	"Pena",
	"Richards",
	"Contreras",
	"Willis",
	"Carpenter",
	"Lawrence",
	"Sandoval",
	"Guerrero",
	"George",
	"Chapman",
	"Rios",
	"Estrada",
	"Ortega",
	"Watkins",
	"Greene",
	"Nunez",
	"Wheeler",
	"Valdez",
	"Harper",
	"Burke",
	"Larson",
	"Santiago",
	"Maldonado",
	"Morrison",
	"Franklin",
	"Carlson",
	"Austin",
	"Dominguez",
	"Carr",
	"Lawson",
	"Jacobs",
	"O'Brien",
	"Lynch",
	"Singh",
	"Vega",
	"Bishop",
	"Montgomery",
	"Oliver",
	"Jensen",
	"Harvey",
	"Williamson",
	"Gilbert",
	"Dean",
	"Sims",
	"Espinoza",
	"Howell",
	"Li",
	"Wong",
	"Reid",
	"Hanson",
	"Le",
	"McCoy",
	"Garrett",
	"Burton",
	"Fuller",
	"Wang",
	"Weber",
	"Welch",
	"Rojas",
	"Lucas",
	"Marquez",
	"Fields",
	"Park",
	"Yang",
	"Little",
	"Banks",
	"Padilla",
	"Day",
	"Walsh",
	"Bowman",
	"Schultz",
	"Luna",
	"Fowler",
	"Mejia",
	"Davidson",
	"Acosta",
	"Brewer",
	"May",
	"Holland",
	"Juarez",
	"Newman",
	"Pearson",
	"Curtis",
	"Cortez",
	"Douglas",
	"Schneider",
	"Joseph",
	"Barrett",
	"Navarro",
	"Figueroa",
	"Keller",
	"Avila",
	"Wade",
	"Molina",
	"Stanley",
	"Hopkins",
	"Campos",
	"Barnett",
	"Bates",
	"Chambers",
	"Caldwell",
	"Beck",
	"Lambert",
	"Miranda",
	"Byrd",
	"Craig",
	"Ayala",
	"Lowe",
	"Frazier",
	"Powers",
	"Neal",
	"Leonard",
	"Gregory",
	"Carrillo",
	"Sutton",
	"Fleming",
	"Rhodes",
	"Shelton",
	"Schwartz",
	"Norris",
	"Jennings",
	"Watts",
	"Duran",
	"Walters",
	"Cohen",
	"McDaniel",
	"Moran",
	"Parks",
	"Steele",
	"Vaughn",
	"Becker",
	"Holt",
	"Deleon",
	"Barker",
	"Terry",
	"Hale",
	"Leon",
	"Hail",
	"Benson",
	"Haynes",
	"Horton",
	"Miles",
	"Lyons",
	"Pham",
	"Graves",
	"Bush",
	"Thornton",
	"Wolfe",
	"Warner",
	"Cabrera",
	"McKinney",
	"Mann",
	"Zimmerman",
	"Dawson",
	"Lara",
	"Fletcher",
	"Page",
	"McCarthy",
	"Love",
	"Robles",
	"Cervantes",
	"Solis",
	"Erickson",
	"Reeves",
	"Chang",
	"Klein",
	"Salinas",
	"Fuentes",
	"Baldwin",
	"Daniel",
	"Simon",
	"Velasquez",
	"Hardy",
	"Higgins",
	"Aguirre",
	"Lin",
	"Cummings",
	"Chandler",
	"Sharp",
	"Barber",
	"Bowen",
	"O'Choa",
	"Dennis",
	"Robbins",
	"Liu",
	"Ramsey",
	"Francis",
	"Griffith",
	"Paul",
	"Blair",
	"O'Connor",
	"Cardenas",
	"Pacheco",
	"Cross",
	"Calderon",
	"Quinn",
	"Moss",
	"Swanson",
	"Chan",
	"Rivas",
	"Khan",
	"Rodgers",
	"Serrano",
	"Fitzgerald",
	"Rosales",
	"Stevenson",
	"Christensen",
	"Manning",
	"Gill",
	"Curry",
	"McLaughlin",
	"Harmon",
	"McGee",
	"Gross",
	"Doyle",
	"Garner",
	"Newton",
	"Burgess",
	"Reese",
	"Walton",
	"Blake",
	"Trujillo",
	"Adkins",
	"Brady",
	"Goodman",
	"Roman",
	"Webster",
	"Goodwin",
	"Fischer",
	"Huang",
	"Potter",
	"Delacruz",
	"Montoya",
	"Todd",
	"Wu",
	"Hines",
	"Mullins",
	"Castaneda",
	"Malone",
	"Cannon",
	"Tate",
	"Mack",
	"Sherman",
	"Hubbard",
	"Hodges",
	"Zhang",
	"Guerra",
	"Wolf",
	"Valencia",
	"Saunders",
	"Franco",
	"Rowe",
	"Gallagher",
	"Farmer",
	"Hammond",
	"Hampton",
	"Townsend",
	"Ingram",
	"Wise",
	"Gallegos",
	"Clarke",
	"Barton",
	"Schroeder",
	"Maxwell",
	"Waters",
	"Logan",
	"Camacho",
	"Strickland",
	"Norman",
	"Person",
	"Colon",
	"Parsons",
	"Frank",
	"Harrington",
	"Glover",
	"Osborne",
	"Buchanan",
	"Casey",
	"Floyd",
	"Patton",
	"Ibarra",
	"Ball",
	"Tyler",
	"Suarez",
	"Bowers",
	"Orozco",
	"Salas",
	"Cobb",
	"Gibbs",
	"Andrade",
	"Bauer",
	"Conner",
	"Moody",
	"Escobar",
	"McGuire",
	"Lloyd",
	"Mueller",
	"Hartman",
	"French",
	"Kramer",
	"McBride",
	"Pope",
	"Lindsey",
	"Velazquez",
	"Norton",
	"McCormick",
	"Sparks",
	"Flynn",
	"Yates",
	"Hogan",
	"Marsh",
	"Macias",
	"Villanueva",
	"Zamora",
	"Pratt",
	"Stokes",
	"Owen",
	"Ballard",
	"Lang",
	"Brock",
	"Villarreal",
	"Charles",
	"Drake",
	"Barrera",
	"Cain",
	"Patrick",
	"Pineda",
	"Burnett",
	"Mercado",
	"Santana",
	"Shepherd",
	"Bautista",
	"Ali",
	"Shaffer",
	"Lamb",
	"Trevino",
	"McKenzie",
	"Hess",
	"Beil",
	"Olsen",
	"Cochran",
	"Morton",
	"Nash",
	"Wilkins",
	"Petersen",
	"Briggs",
	"Shah",
	"Roth",
	"Nicholson",
	"Holloway",
	"Lozano",
	"Rangel",
	"Flowers",
	"Hoover",
	"Short",
	"Arias",
	"Mora",
	"Valenzuela",
	"Bryan",
	"Meyers",
	"Weiss",
	"Underwood",
	"Bass",
	"Greer",
	"Summers",
	"Houston",
	"Carson",
	"Morrow",
	"Clayton",
	"Whitaker",
	"Decker",
	"Yoder",
	"Collier",
	"Zuniga",
	"Carey",
	"Wilcox",
	"Melendez",
	"Poole",
	"Roberson",
	"Larsen",
	"Conley",
	"Davenport",
	"Copeland",
	"Massey",
	"Lam",
	"Huff",
	"Rocha",
	"Cameron",
	"Jefferson",
	"Hood",
	"Monroe",
	"Anthony",
	"Pittman",
	"Huynh",
	"Randall",
	"Singleton",
	"Kirk",
	"Combs",
	"Mathis",
	"Christian",
	"Skinner",
	"Bradford",
	"Richard",
	"Galvan",
	"Wall",
	"Boone",
	"Kirby",
	"Wilkinson",
	"Bridges",
	"Bruce",
	"Atkinson",
	"Velez",
	"Meza",
	"Roy",
	"Vincent",
	"York",
	"Hodge",
	"Villa",
	"Abbott",
	"Allison",
	"Tapia",
	"Gates",
	"Chase",
	"Sosa",
	"Sweeney",
	"Farrell",
	"Wyatt",
	"Dalton",
	"Horn",
	"Barron",
	"Phelps",
	"Yu",
	"Dickerson",
	"Heath",
	"Foley",
	"Atkins",
	"Mathews",
	"Bonilla",
	"Acevedo",
	"Benitez",
	"Zavala",
	"Hensley",
	"Glenn",
	"Cisneros",
	"Harrell",
	"Shields",
	"Rubio",
	"Huffman",
	"Choi",
	"Boyer",
	"Garrison",
	"Arroyo",
	"Bond",
	"Kane",
	"Hancock",
	"Callahan",
	"Dillon",
	"Cline",
	"Wiggins",
	"Grimes",
	"Arellano",
	"Melton",
	"O'Neill",
	"Savage",
	"Ho",
	"Beltran",
	"Pitts",
	"Parrish",
	"Ponce",
	"Rich",
	"Booth",
	"Koch",
	"Golden",
	"Ware",
	"Brennan",
	"McDowell",
	"Marks",
	"Cantu",
	"Humphrey",
	"Baxter",
	"Sawyer",
	"Clay",
	"Tanner",
	"Hutchinson",
	"Kaur",
	"Berg",
	"Wiley",
	"Gilmore",
	"Russo",
	"Villegas",
	"Hobbs",
	"Keith",
	"Wilkerson",
	"Ahmed",
	"Beard",
	"McClain",
	"Montes",
	"Mata",
	"Rosario",
	"Vang",
	"Walter",
	"Henson",
	"O'Neal",
	"Mosley",
	"McClure",
	"Beasley",
	"Stephenson",
	"Snow",
	"Huerta",
	"Preston",
	"Vance",
	"Barry",
	"Johns",
	"Eaton",
	"Blackwell",
	"Dyer",
	"Prince",
	"Macdonald",
	"Solomon",
	"Guevara",
	"Stafford",
	"English",
	"Hurst",
	"Woodard",
	"Cortes",
	"Shannon",
	"Kemp",
	"Nolan",
	"McCullough",
	"Merritt",
	"Murillo",
	"Moon",
	"Salgado",
	"Strong",
	"Kline",
	"Cordova",
	"Barajas",
	"Roach",
	"Rosas",
	"Winters",
	"Jacobson",
	"Lester",
	"Knox",
	"Bullock",
	"Kerr",
	"Leach",
	"Meadows",
	"Orr",
	"Davila",
	"Whitehead",
	"Pruitt",
	"Kent",
	"Conway",
	"McKee",
	"Barr",
	"David",
	"Dejesus",
	"Marin",
	"Berger",
	"McIntyre",
	"Blankenship",
	"Gaines",
	"Palacios",
	"Cuevas",
	"Bartlett",
	"Durham",
	"Dorsey",
	"McCall",
	"O'Donnell",
	"Stein",
	"Browning",
	"Stout",
	"Lowery",
	"Sloan",
	"McLean",
	"Hendricks",
	"Calhoun",
	"Sexton",
	"Chung",
	"Gentry",
	"Hull",
	"Duarte",
	"Ellison",
	"Nielsen",
	"Gillespie",
	"Buck",
	"Middleton",
	"Sellers",
	"Leblanc",
	"Esparza",
	"Hardin",
	"Bradshaw",
	"McIntosh",
	"Howe",
	"Livingston",
	"Frost",
	"Glass",
	"Morse",
	"Knapp",
	"Herman",
	"Stark",
	"Bravo",
	"Noble",
	"Spears",
	"Weeks",
	"Corona",
	"Frederick",
	"Buckley",
	"McFarland",
	"Hebert",
	"Enriquez",
	"Hickman",
	"Quintero",
	"Randolph",
	"Schaefer",
	"Walls",
	"Trejo",
	"House",
	"Reilly",
	"Pennington",
	"Michael",
	"Conrad",
	"Giles",
	"Benjamin",
	"Crosby",
	"Fitzpatrick",
	"Donovan",
	"Mays",
	"Mahoney",
	"Valentine",
	"Raymond",
	"Medrano",
	"Hahn",
	"McMillan",
	"Small",
	"Bentley",
	"Felix",
	"Peck",
	"Lucero",
	"Boyle",
	"Hanna",
	"Pace",
	"Rush",
	"Hurley",
	"Harding",
	"McConnell",
	"Bernal",
	"Nava",
	"Ayers",
	"Everett",
	"Ventura",
	"Avery",
	"Pugh",
	"Mayer",
	"Bender",
	"Shepard",
	"McMahon",
	"Landry",
	"Case",
	"Sampson",
	"Moses",
	"Magana",
	"Blackburn",
	"Dunlap",
	"Gould",
	"Duffy",
	"Vaughan",
	"Herring",
	"McKay",
	"Espinosa",
	"Rivers",
	"Farley",
	"Bernard",
	"Ashley",
	"Friedman",
	"Potts",
	"Truong",
	"Costa",
	"Correa",
	"Blevins",
	"Nixon",
	"Clements",
	"Fry",
	"Delarosa",
	"Best",
	"Benton",
	"Lugo",
	"Portillo",
	"Dougherty",
	"Crane",
	"Haley",
	"Phan",
	"Villalobos",
	"Blanchard",
	"Horne",
	"Finley",
	"Quintana",
	"Lynn",
	"Esquivel",
	"Bean",
	"Dodson",
	"Mullen",
	"Xiong",
	"Hayden",
	"Cano",
	"Levy",
	"Huber",
	"Richmond",
	"Moyer",
	"Lim",
	"Frye",
	"Sheppard",
	"McCarty",
	"Avalos",
	"Booker",
	"Waller",
	"Parra",
	"Woodward",
	"Jaramillo",
	"Krueger",
	"Rasmussen",
	"Brandt",
	"Peralta",
	"Donaldson",
	"Stuart",
	"Faulkner",
	"Maynard",
	"Galindo",
	"Coffey",
	"Estes",
	"Sanford",
	"Burch",
	"Maddox",
	"Vo",
	"O'Connell",
	"Vu",
	"Andersen",
	"Spence",
	"McPherson",
	"Church",
	"Schmitt",
	"Stanton",
	"Leal",
	"Cherry",
	"Compton",
	"Dudley",
	"Sierra",
	"Pollard",
	"Alfaro",
	"Hester",
	"Proctor",
	"Lu",
	"Hinton",
	"Novak",
	"Good",
	"Madden",
	"McCann",
	"Terrell",
	"Jarvis",
	"Dickson",
	"Reyna",
	"Cantrell",
	"Mayo",
	"Branch",
	"Hendrix",
	"Rollins",
	"Rowland",
	"Whitney",
	"Duke",
	"Odom",
	"Daugherty",
	"Travis",
	"Tang",
];

var iNextName = 0;


function SetName(bd, iName)
{
  var strTag = vNameTag[iName];
  var strName = bd.TagValue(strTag);
  if (!strName)
    return;

  var strAnon = mapName[strName + '$'];
  if (!strAnon) {
    strAnon = vName[iNextName++];
    if (!strAnon) {
      bc.alert('Anonymize.js: Ran out of names', MB_ICONERROR);
      WScript.Quit(1);
    }

    mapName[strName + '$'] = strAnon;
  }

  bd.TagValue(strTag) = strAnon;
}


(function () {
  Shuffle(vName);
  var d = new Date;
  var bds = bc.Boards;
  while (bds.MoveNext()) {
    var bd = bds.Current;
    bd.TagValue('Event') = "Afternoon Open Pairs";
    bd.TagValue('Site') = "BridgeComposer Bridge Club";
    bd.TagValue('Date') = d.getFullYear() + '.' + Pad(d.getMonth() + 1) + '.' + Pad(d.getDate());

    for (var i in vNameTag) {
      SetName(bd, i);
    }
  }

  bc.Save();
})();

